<?php

// Function to fetch HTML content via cURL
function fetchHTML($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
    $html = curl_exec($ch);
    curl_close($ch);
    return $html;
}

// Function to extract data from a page
function extractData($html) {
    $dom = new DOMDocument();
    libxml_use_internal_errors(true); // Suppress warnings
    $dom->loadHTML($html);
    libxml_clear_errors();

    $xpath = new DOMXPath($dom);

    // Check if the page contains the class 'cms-block-container'
    if ($xpath->query("//div[contains(@class, 'cms-block-container')]")->length == 0) {
        return []; // Skip this page if the class doesn't exist
    }

    // Query elements with class 'cms-teaser-image' and 'cms-teaser-image-link'
    $imageElements = $xpath->query("//img[contains(@class, 'cms-teaser-image')]");
    $linkElements = $xpath->query("//a[contains(@class, 'cms-teaser-image-link')]");

    $data = [];

    // Extract 'src' from 'cms-teaser-image'
    foreach ($imageElements as $key => $image) {
        $data[$key]['src'] = $image->getAttribute('src');
    }

    // Extract 'href' and 'title' from 'cms-teaser-image-link'
    foreach ($linkElements as $key => $link) {
        $data[$key]['href'] = $link->getAttribute('href');
        $data[$key]['title'] = $link->getAttribute('title');
    }

    return $data;
}

// Main URL
$mainUrl = 'https://www.versagroup.be/en/All-Products/';
$mainHtml = fetchHTML($mainUrl);

// Extract data from the main page
$mainData = extractData($mainHtml);

// Visit each href from the main page and fetch data from those pages
foreach ($mainData as $key => &$parent) {
    if (isset($parent['href'])) {
        // Replace the specific redirecting link
        if ($parent['href'] === '/en/All-Products/Metal-Products/') {
            $parent['href'] = '/en/All-Products//Installation-Materials/';
        }

        // Build the absolute URL for the child page
        $childUrl = 'https://www.versagroup.be' . $parent['href'];
        $childHtml = fetchHTML($childUrl);

        // Extract data from the child page
        $childData = extractData($childHtml);

        // Add the child data under a subarray in the parent
        $parent['subarray'] = $childData;
    }
}

// Output the final data structure
echo "<pre>";print_r($mainData);

