<?php
// Load the saved .txt file
$file = 'updated_all_href_links_without_sorting.txt'; // Path to the uploaded file

if (file_exists($file)) {
    $content = file_get_contents($file);
    $allLinks = json_decode($content, true); // Convert JSON string back to array

    echo "Processing Links...\n";

    // Function to fetch HTML content via cURL
    function fetchHTML($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
        $html = curl_exec($ch);
        curl_close($ch);
        return $html;
    }

    // Function to extract product data from a page
    function extractProductData($html) {
        $dom = new DOMDocument();
        libxml_use_internal_errors(true); // Suppress warnings
        $dom->loadHTML($html);
        libxml_clear_errors();

        $xpath = new DOMXPath($dom);

        // Find the first <h2> with class "mb-4"
        $h2 = $xpath->query("//h2[contains(@class, 'mb-4')]");
        if ($h2->length > 0) {
            // Find the first <div> with class "cms-element-product-listing" after <h2>
            $productDiv = $xpath->query("following-sibling::div[contains(@class, 'cms-element-product-listing')]", $h2->item(0));
            if ($productDiv->length > 0) {
                $productDivNode = $productDiv->item(0);

                // Extract product details from the found div
                $productLinks = $xpath->query(".//a[contains(@class, 'product-image-link')]", $productDivNode);
                $productImages = $xpath->query(".//img[contains(@class, 'product-image')]", $productDivNode);

                $products = [];
                foreach ($productLinks as $key => $link) {
                    $products[$key]['href'] = $link->getAttribute('href');
                }
                foreach ($productImages as $key => $image) {
                    $products[$key]['src'] = $image->getAttribute('src');
                    $products[$key]['title'] = $image->getAttribute('alt'); // Replace 'alt' with 'title'
                }

                return $products;
            }
        }

        return [];
    }

    // Process each link in the array
    $allProductData = [];
    foreach ($allLinks as $link) {
        echo "Processing: $link\n";

        // Fetch HTML content for the page
        $html = fetchHTML($link);

        // Check if the HTML was fetched successfully
        if (!$html) {
            echo "Failed to fetch HTML for $link\n";
            continue;
        }

        // Extract product data
        $productData = extractProductData($html);

        // Add to the final array
        if (!empty($productData)) {
            $allProductData[] = [
                'url' => $link,
                'products' => $productData,
            ];
        } else {
            echo "No product data found for $link\n";
        }
    }

    // Output the final data structure
    echo "<pre>";
    print_r($allProductData);
    echo "</pre>";

    // Extract all 'href' elements from the products subarray
    $allProductLinks = [];
    foreach ($allProductData as $product) {
        if (isset($product['products'])) {
            foreach ($product['products'] as $item) {
                if (isset($item['href'])) {
                    // Prefix with base URL if not already present
                    $allProductLinks[] = (strpos($item['href'], 'https://www.versagroup.be') === 0)
                        ? $item['href']
                        : 'https://www.versagroup.be' . $item['href'];
                }
            }
        }
    }

    // Add the array of product links to the final data
    $allProductData['product_links'] = $allProductLinks;

    echo "<pre>";
    print_r($allProductData);
    echo "</pre>";


    // Save the results to a file
    $outputFile = 'final_product_data.txt';
    file_put_contents($outputFile, json_encode($allProductData, JSON_PRETTY_PRINT));

    echo "Product data saved to $outputFile.\n";
} else {
    echo "File $file not found.";
}
?>
